/************************************************************************
 * @file: AudioFaderTest.cpp
 *
 * @description: Unit Test for GDA.
 *
 * @authors: Athreya Manasa Balaraj, ManasaBalaraj.Athreya@in.bosch.com 2017
 *           Devi Laxmi, Laxmi.Devi@in.bosch.com 2017
 *
 * copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 ***********************************************************************/

#include <dlt/dlt.h>
#include <string.h>
#include <unistd.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <stdio.h>

/*! @file gst_player.c
 *  Simple gstreamer application.
 */
#include "gst_player.h"

GDA_ER
gst_initialize (player_info_t * player_info)
{
    char context_id[DLT_ID_SIZE];
    GDA_ER err = GDA_OK;

    sprintf(context_id,"GT%02d",player_info->player_inst);
    err = GDA_REGISTER_LOGGING (&player_info->gda_ctx, context_id,"GStreamer context", DLT_SERVICEID);
    if(GDA_OK != err)
    {
        g_print("GDA APP : GDA Register logging failed\n");
    }
    return err;
}

/* GstMessage posted by streaming thread on bus will be handled here*/
static gboolean
gst_watch (GstBus * bus, GstMessage * message, gpointer data)
{
    GstStreamStatusType type;
    sync_handler_data_t *handler_data = (sync_handler_data_t*) data;
    bus = bus;

    if (GST_MESSAGE_TYPE (message) == GST_MESSAGE_EOS)
    {
        g_main_loop_quit (handler_data->loop);
    }
    if (GST_MESSAGE_TYPE (message) == GST_MESSAGE_STREAM_STATUS)
    {
        gst_message_parse_stream_status (message, &type, NULL);
        if (type == GST_STREAM_STATUS_TYPE_CREATE || type == GST_STREAM_STATUS_TYPE_ENTER)
        {
            GDA_REGISTER_THREAD_TO_CONTEXT (g_thread_self(), (const char* )handler_data->dlt_contextID);
        }
    }

    return TRUE;
}

void*
gst_create_pipeline_thread (void * data)
{
    GMainLoop  *loop;
    GstElement *pipeline;
    GstBus     *bus;
    char       *pipeline_command;
    uint32_t   pipeline_command_sz;
    sync_handler_data_t sync_handler_data;

    player_info_t *player_info = (player_info_t*) data;

    /*pipeline creation*/
    loop = g_main_loop_new (NULL, FALSE);

    /* Do not edit the below message, GDA smoketest will check the dlt log for this message */
    /*PRQA: Lint Message 774 : Warning from GStreamer code. Cant be fixed */
    /*lint -save -e774*/
    GST_INFO("Hello world, This is GDA routing GStreamer logs");
    /*lint -restore */

#define PIPELINE_SRC "filesrc location ="
#define PIPELINE_SRC_PATH (player_info->filename)
#define PIPELINE_DEC_ALSA " ! decodebin ! alsasink device=entertainment_main"
#define PIPELINE_DEC_FILESINK " ! decodebin ! filesink location=/tmp/music_"
#define PIPELINE_FILE_EXT ".ogg"

    if(0 == player_info->player_inst)
    {
        pipeline_command_sz = strlen(PIPELINE_SRC) + strlen(PIPELINE_SRC_PATH) +
                strlen(PIPELINE_DEC_ALSA) + 1;
        pipeline_command = calloc(1, pipeline_command_sz);
        if(NULL == pipeline_command)
        {
            g_print("Memory allocation failed");
            return NULL;
        }
        snprintf(pipeline_command, pipeline_command_sz, "%s%s%s",PIPELINE_SRC,
                PIPELINE_SRC_PATH, PIPELINE_DEC_ALSA);
    }
    else
    {
        pipeline_command_sz = strlen(PIPELINE_SRC)+ strlen(PIPELINE_SRC_PATH) +
                strlen(PIPELINE_DEC_FILESINK) + strlen(PIPELINE_FILE_EXT) + sizeof(int) + 1;
        pipeline_command = calloc(1, pipeline_command_sz);
        if(NULL == pipeline_command)
        {
            g_print("Memory allocation failed");
            return NULL;
        }
        snprintf(pipeline_command, pipeline_command_sz, "%s%s%s%02d%s",PIPELINE_SRC,
                PIPELINE_SRC_PATH, PIPELINE_DEC_FILESINK, player_info->player_inst, PIPELINE_FILE_EXT);
    }
    pipeline = gst_parse_launch (pipeline_command, NULL);
    /*PRQA: Lint Message 826 : Pointer to Pointer conversion fails */
    /*lint -save -e826*/
    bus = gst_pipeline_get_bus (GST_PIPELINE (pipeline));
    /*lint -restore */
    memset(sync_handler_data.dlt_contextID, '\0', DLT_ID_SIZE);
    strncpy(sync_handler_data.dlt_contextID,player_info->gda_ctx.dlt_ctx.contextID,DLT_ID_SIZE);
    sync_handler_data.loop = loop;
#ifdef GST_VERSION_1
    gst_bus_set_sync_handler (bus, (GstBusSyncHandler)gst_watch, &sync_handler_data, NULL);
#else
    gst_bus_set_sync_handler (bus, (GstBusSyncHandler)gst_watch, &sync_handler_data);
#endif
    gst_object_unref (bus);

    gst_element_set_state (pipeline, GST_STATE_PLAYING);
    g_main_loop_run (loop);
    gst_element_set_state (pipeline, GST_STATE_NULL);
    /*PRQA: Lint Message 826 : Pointer to Pointer conversion fails */
    /*lint -save -e826*/
    gst_object_unref (GST_OBJECT (pipeline));
    /*lint -restore*/
    free(pipeline_command);
    return NULL;
}

GDA_ER
gst_finalize (GDA_CTX  * gda_ctx)
{
    GDA_ER err = GDA_OK;
    err = GDA_UNREGISTER_LOGGING (gda_ctx);
    if(GDA_OK != err)
    {
        g_print("GDA APP : GDA Unregister logging failed\n");
    }
    return err;
}
